/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: OmbOmb_DiagStructDef.h 3661 2015-09-30 07:19:11Z iborisov $:
Description:
Omb Task
Includes following functions...
**************************************************************************************/

#ifndef __STRUCT_OMB_OMB_INFO_STATUS__
#define __STRUCT_OMB_OMB_INFO_STATUS__
typedef __PACKED_PRE struct __PACKED_POST OMB_OMB_INFO_STATUStag {
  /*  Task State */
  UINT32 ulTaskState;
  /*  Error Count */
  UINT32 ulErrorCount;
  /*  Last Error */
  UINT32 ulLastError;
  /*  Socket Status */
  UINT32 ulOpenSockets;
  /*  Cyclic Event Count */
  UINT32 ulCyclicCount;
  /*  Idle Count */
  UINT32 ulIdleCount;
} OMB_OMB_INFO_STATUS;
#endif
#ifndef __STRUCT_OMB_OMB_CLIENT_STATUS__
#define __STRUCT_OMB_OMB_CLIENT_STATUS__
typedef __PACKED_PRE struct __PACKED_POST OMB_OMB_CLIENT_STATUStag {
  /*  Messages Send to User */
  UINT32 ulMsgSend;
  /*  Messages Recv from User */
  UINT32 ulMsgRecv;
  /*  FC1  Count */
  UINT32 ulFc1Cnt;
  /*  FC2  Count */
  UINT32 ulFc2Cnt;
  /*  FC3  Count */
  UINT32 ulFc3Cnt;
  /*  FC4  Count */
  UINT32 ulFc4Cnt;
  /*  FC5  Count */
  UINT32 ulFc5Cnt;
  /*  FC6  Count */
  UINT32 ulFc6Cnt;
  /*  FC7  Count */
  UINT32 ulFc7Cnt;
  /*  FC15 Count */
  UINT32 ulFc15Cnt;
  /*  FC16 Count */
  UINT32 ulFc16Cnt;
  /*  FC23 Count */
  UINT32 ulFc23Cnt;
} OMB_OMB_CLIENT_STATUS;
#endif
#ifndef __STRUCT_OMB_OMB_SERVER_STATUS__
#define __STRUCT_OMB_OMB_SERVER_STATUS__
typedef __PACKED_PRE struct __PACKED_POST OMB_OMB_SERVER_STATUStag {
  /*  Messages Send to TCP-Task */
  UINT32 ulMsgSend;
  /*  Messages Recv from TCP-Task */
  UINT32 ulMsgRecv;
  /*  FC1  Count */
  UINT32 ulFc1Cnt;
  /*  FC2  Count */
  UINT32 ulFc2Cnt;
  /*  FC3  Count */
  UINT32 ulFc3Cnt;
  /*  FC4  Count */
  UINT32 ulFc4Cnt;
  /*  FC5  Count */
  UINT32 ulFc5Cnt;
  /*  FC6  Count */
  UINT32 ulFc6Cnt;
  /*  FC7  Count */
  UINT32 ulFc7Cnt;
  /*  FC15 Count */
  UINT32 ulFc15Cnt;
  /*  FC16 Count */
  UINT32 ulFc16Cnt;
  /*  FC23 Count */
  UINT32 ulFc23Cnt;
} OMB_OMB_SERVER_STATUS;
#endif
#ifndef __STRUCT_OMB_OMB_IO_STATUS__
#define __STRUCT_OMB_OMB_IO_STATUS__
typedef __PACKED_PRE struct __PACKED_POST OMB_OMB_IO_STATUStag {
  /*  Messages Send to TCP-Task */
  UINT32 ulMsgSend;
  /*  Messages Recv from TCP-Task */
  UINT32 ulMsgRecv;
  /*  FC1  Count */
  UINT32 ulFc1Cnt;
  /*  FC2  Count */
  UINT32 ulFc2Cnt;
  /*  FC3  Count */
  UINT32 ulFc3Cnt;
  /*  FC4  Count */
  UINT32 ulFc4Cnt;
  /*  FC5  Count */
  UINT32 ulFc5Cnt;
  /*  FC6  Count */
  UINT32 ulFc6Cnt;
  /*  FC7  Count */
  UINT32 ulFc7Cnt;
  /*  FC15 Count */
  UINT32 ulFc15Cnt;
  /*  FC16 Count */
  UINT32 ulFc16Cnt;
  /*  FC23 Count */
  UINT32 ulFc23Cnt;
  /*  Modbus address */
  UINT16 usModbusAdr;
  /*  Data count */
  UINT16 usDataCnt;
  /*  Function code */
  UINT16 usFunction;
  /*  Data */
  UINT16 ausData[3];
  /*  Error Count */
  UINT32 ulErrorCount;
  /*  Last Error */
  UINT32 ulLastError;
  /* Process data watchdog event counter */
  UINT32 ulPdwEventCounter;
} OMB_OMB_IO_STATUS;
#endif
#ifndef __STRUCT_MID_CDG_CODE_DIAG__
#define __STRUCT_MID_CDG_CODE_DIAG__
typedef __PACKED_PRE struct __PACKED_POST MID_CDG_CODE_DIAGtag {
  /*  Info Count */
  UINT32 ulInfoCnt;
  /*  Warning Count */
  UINT32 ulWarningCnt;
  /*  Error Count */
  UINT32 ulErrorCnt;
  /*  Severity Level */
  UINT32 ulDiagLevel;
  /*  Code */
  UINT32 ulErrorCode;
  /*  Parameter */
  UINT32 ulUserParam;
  /*  Module */
  STRING abCodeDiagFilename[32];
  /*  Line Number */
  INT32 lLine;
  /*  Resource Pointer (hidden!!) */
  UINT32 ulRsc;
} MID_CDG_CODE_DIAG;
#endif
